# ColorTokens AWS account ID that will assume this role.
# Get the correct value from the Xshield portal (Cloud Connectors → AWS → Manual).
# Default is a placeholder so that running terraform apply by accident will not
# create a role usable in production.
variable "colortokens_account_id" {
  description = "AWS account ID of ColorTokens (the principal that will assume this role)"
  type        = string
  default     = "XXXXXXXXXXXX"
}

variable "role_name" {
  description = "Name of the IAM role for ColorTokens cross-account access"
  type        = string
  default     = "ColorTokensCrossAccountAccessRole"
}

variable "tags" {
  description = "Tags to apply to the IAM role"
  type        = map(string)
  default     = {}
}
