# Sample Terraform: Xshield Cloud Connector (AWS) cross-account role

This sample creates the IAM role and permissions required for **manual (Path B)** onboarding of an AWS account to the Xshield Cloud Connector. It does **not** use CloudFormation or any notification (SNS) resources; after applying, you complete the connection in the Xshield portal.

## Prerequisites

- Terraform >= 1.0
- AWS provider configured (credentials for the **customer** AWS account where the role will be created)
- The **ColorTokens account ID** from the Xshield portal (Cloud Connectors → AWS → Manual onboarding). The default in this sample is a placeholder (`XXXXXXXXXXXX`) so that running `terraform apply` by accident will not create a production-usable role.

## Usage

1. **Get the ColorTokens account ID** from the Xshield portal (Cloud Connectors → AWS → Manual). It is the AWS account ID that will assume this role.

2. **Configure the variable** (one of):
   - Create a `terraform.tfvars` file:
     ```hcl
     colortokens_account_id = "123456789012"   # replace with value from portal
     ```
   - Or pass on the command line:
     ```bash
     terraform apply -var="colortokens_account_id=123456789012"
     ```

3. **Apply**:
   ```bash
   terraform init
   terraform plan
   terraform apply
   ```

4. **Complete onboarding in the Xshield portal**  
   Go to Cloud Connectors → AWS → Manual onboarding → **Step 3: Enter Account Details**. Enter your **Account Name** and **AWS Account ID** (the account where you ran Terraform), then click **Verify** and **Connect**.

## Outputs

- `role_arn` – Use this (or your Account ID + role name) when verifying in the portal.
- `role_name` – Default: `ColorTokensCrossAccountAccessRole`.

## Files

- `main.tf` – IAM role (trust policy) and inline policy (permissions).
- `variables.tf` – `colortokens_account_id` (default `XXXXXXXXXXXX`), `role_name`, `tags`.
- `outputs.tf` – Role ARN and name.

## Notes

- This sample does **not** create or reference any SNS topic; notifications are only used with the CloudFormation (Path A) flow.
- If the Xshield CloudFormation template is updated with new actions, update the `colortokens_access` policy in `main.tf` to match.
